<?php

include_once 'conexao.php';
  
class ModeloPergunta
{   
	static public function mdlAddPergunta($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO pergunta 
						(pergunta, idRecrutador, dataCadastro,idVaga,ordem,imagem,idExercicioTema,tempoParaResponder) VALUES (:pergunta, :idRecrutador, :dataCadastro,:idVaga,:ordem,:imagem,:idExercicioTema,:tempoParaResponder)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":pergunta", $dados["pergunta"], PDO::PARAM_STR);
		$stmt->bindParam(":pergunta", $dados["pergunta"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":ordem", $dados["ordem"], PDO::PARAM_STR);
		$stmt->bindParam(":idRecrutador", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":imagem", $dados["imagem"], PDO::PARAM_STR);
		$stmt->bindParam(":idExercicioTema", $dados["idExercicioTema"], PDO::PARAM_STR);
		$stmt->bindParam(":tempoParaResponder", $dados["tempoParaResponder"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	} 

	static public function mdlMostrarTodasAsPerguntasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idExercicioTema = '' order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  
 
	static public function mdlMostrarTodasAsPerguntasDaAvaliacaoDoTemaPoridVagaEIdTema($idVaga, $idTema) { 

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idExercicioTema = :idTema order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  

	static public function mdlMostrarDadosDaPerguntasDaAvaliacaoDoTemaPoridVagaEIdTemaEPegunta($idVaga, $idTema, $pergunta) { 

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idExercicioTema = :idTema and pergunta = :pergunta order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 

	static public function mdlMostrarEOrdenarPerguntasPorNumeroDeOrdemTodasAsPerguntasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	static public function mdlMostrarEOrdenarPerguntasTodasPerguntasDaAvaliacaoPorIdVagaEIdTema($idVaga,$idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idExercicioTema = :idTema order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();
 
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	static public function mdlVerificarPerguntaPoridVagaEPregunta($idVaga,$pergunta) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and pergunta = :pergunta order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 
 
	static public function mdlMostrarPerguntaPorIdPergunta($idPergunta) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idPergunta = :idPergunta");
			$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarPerguntaPoridVagaENumeroDeOrdem($idVaga,$ordem) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and ordem = :ordem");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":ordem", $ordem, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	static public function mdlMostrarPerguntaDaAvaliacaoPoridVagaENumeroDeOrdemEIdTema($idVaga,$ordem,$idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and ordem = :ordem and idExercicioTema = :idTema");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":ordem", $ordem, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	

	static public function mdlEditarPergintaPorIdPergunta($idPergunta, $ordem,$pergunta){
 
		$stmt = Conexao::conectar()->prepare("UPDATE pergunta SET ordem = :ordem, pergunta = :pergunta where idPergunta = :idPergunta ");
		$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
		$stmt->bindParam(":ordem", $ordem, PDO::PARAM_STR);
		$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEditarPerguntaPorIdPergunta($idPergunta, $pergunta){
 
		$stmt = Conexao::conectar()->prepare("UPDATE pergunta SET  pergunta = :pergunta where idPergunta = :idPergunta ");
		$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
		$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}
 
	static public function mdlEliminarPerguntaPorIdPergunta($id){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM pergunta where idPergunta = :id ");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>